package cn.com.duiba.kjy.livecenter.api.dto.share;

import cn.com.duiba.kjy.livecenter.api.enums.live.share.ShareTypeApiEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 直播间分享参数
 * @author lizhi
 * @date 2020/4/12 11:48 AM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class LiveRoomShareApiBean extends ShareApiBean {

    private static final long serialVersionUID = 7184736525915413555L;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 分享人的userID
     */
    private Long sharedUserId;

    /**
     * 是否本场直播代理人
     */
    private boolean liveAgent;

    /**
     * 代理人ID
     */
    private Long agentId;

    public LiveRoomShareApiBean() {
        super(ShareTypeApiEnum.VISITOR_MP_LIVE_ROOM_INVITATION.getCode());
    }
}
