package cn.com.duiba.kjy.livecenter.api.param.open;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 直播线索-合作方客户投票记录
 * @author kjj mybatis generator 
 * @date 2020-12-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveClueOpenVoteSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16088614128442251L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * tb_live_agent.id
     */
    private Long agentId;

    /**
     * tb_live_user.id
     */
    private Long liveUserId;

    /**
     * 选择题问题ID，tb_choice_question.id
     */
    private Long voteId;

    /**
     * 投票标题
     */
    private String voteTitle;

    /**
     * 选择题答案ID，tb_choice_answer.id
     */
    private Long choiceAnswerId;

    /**
     * 用户选择
     */
    private String userChoice;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}