package cn.com.duiba.kjy.livecenter.api.util;

import cn.com.duiba.kjy.livecenter.api.dto.share.AgentShareApiBean;
import cn.com.duiba.kjy.livecenter.api.dto.share.LiveRoomShareApiBean;
import cn.com.duiba.kjy.livecenter.api.dto.share.ShareApiBean;
import cn.com.duiba.kjy.livecenter.api.enums.live.share.ShareTypeApiEnum;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * 分享加解密工具类
 *
 * @author lizhi
 * @date 2020/4/12 11:50 AM
 */
public class ApiShareUtils {

    /**
     * 分享签名加密盐
     */
    private static final String SHARE_ENCRYPT = "89f1657ff6a3";

    private ApiShareUtils() {
    }

    /**
     * 平衡加密
     *
     * @param bean 分享参数
     * @return 加密串
     */
    public static <T extends ShareApiBean> String signShareBean(T bean) {
        if (Objects.isNull(bean)) {
            return null;
        }
        ShareTypeApiEnum shareTypeEnum = ShareTypeApiEnum.getByCode(bean.getShareType());
        if (shareTypeEnum == null) {
            return null;
        }
        try {
            return BlowfishUtils.encryptBlowfish(JSON.toJSONString(bean), SHARE_ENCRYPT);
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 解析分享加密串
     *
     * @param sign  加密串
     * @param clazz 参数class
     * @return 分享参数
     */
    public static <T extends ShareApiBean> T decodeShareSign(String sign, Class<T> clazz) {
        if (StringUtils.isBlank(sign) || "undefined".equals(sign) || StringUtils.equals(sign, "null")) {
            return null;
        }
        try {
            String content = BlowfishUtils.decryptBlowfish(sign, SHARE_ENCRYPT);
            JSONObject jsonObject = JSON.parseObject(content);
            T bean = jsonObject.toJavaObject(clazz);
            if (bean == null) {
                return null;
            }
            ShareTypeApiEnum shareTypeEnum = ShareTypeApiEnum.getByCode(bean.getShareType());
            if (shareTypeEnum == null) {
                return null;
            }
            if (!shareTypeEnum.getCode().equals(jsonObject.getInteger("shareType"))) {
                return null;
            }
            return bean;
        } catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(decodeShareSign("2fk2sciqMty6DhNPZ6A18BSQHWKqzMus78LvcrZiJ3B2raJkCz8wyqNSHndCpvtPy6V8b6XSZfnmAEzHcUEfa5DCkZK", AgentShareApiBean.class));
        System.out.println(decodeShareSign("2fk2sciqMty6DhNPZ6A18BSQHWKqzMus78LvcrZiJ3B2raJkCz8wyqNSHndCpvtPy6V8b6XSZfnmAEzHcUEfa5DCkZK", LiveRoomShareApiBean.class));
    }

}
