package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.param.qrcode.OutCreateLiveMpQrCodeParam;
import cn.com.duiba.live.conf.service.api.dto.live.LiveDto;
import cn.com.duiba.live.conf.service.api.dto.live.OuterLiveDto;

import java.util.List;

/**
 * 直播
 * @author lizhi
 * @date 2020/3/30 2:57 PM
 */
@AdvancedFeignClient
public interface RemoteLiveService {

    /**
     * 获取生成小程序码的参数（管理员直播列表分享）
     * @param liveId 直播ID
     * @return 生成小程序码的参数
     */
    OutCreateLiveMpQrCodeParam getMpQrCodeParamV2(Long liveId);

    /**
     * 根据用户Id 查询直播间列表
     * 查代理人所在公司的直播列表
     * @param liveUserId 直播系统用户id
     * @return
     */
    List<OuterLiveDto> findListListByLiveUserId4Kjj(Long liveUserId, Integer pageIndex, Integer pageSize);

    /**
     * 创建/编辑直播间
     *
     * @param liveDto 直播信息
     * @return 直播id
     */
    Long saveOrUpdateLive(LiveDto liveDto);

}
