package cn.com.duiba.kjy.livecenter.api.dto.clue;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 直播用户线索es对象
 * @author 吴文哲
 * @date 2020-09-22 11:59
 **/
@Data
public class LiveUserClueEsDto implements Serializable {
    private static final long serialVersionUID = 797448892684918338L;

    /**
     * tb_live_statistics_user.id
     */
    private Long id;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 代理人id 访客邀请人
     */
    private Long agentId;

    /**
     * 访客直播用户id
     */
    private Long liveVisitorId;

    /**
     * 用户手机号码
     */
    private String userPhone;

    /**
     * 用户头像
     */
    private String userAvatar;

    /**
     * 用户微信昵称
     */
    private String userName;

    /**
     * 线索价值类型
     * 通过用户行为计算获得
     * @see cn.com.duiba.kjy.livecenter.api.enums.clue.LiveClueValueEnums
     */
    private Integer clueValueType;

    /**
     * 用户行为列表
     * @see cn.com.duiba.live.conf.service.api.enums.clue.LiveVisitorActionEnums
     */
    private List<Integer> actionTypeList;

    /**
     * 用户行为分
     */
    private int actionScore;

    /**
     * 已读未读标识 1:已读 0:未读
     * @see cn.com.duiba.kjy.livecenter.api.enums.BooleanEnum
     */
    private Integer readFlag;

    /**
     * 在线时长
     */
    private Integer duration;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}
