package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveCompanyDetailDto;
import cn.com.duiba.kjy.livecenter.api.param.company.LiveCompanyClueCollectorParam;

/**
 * 直播公司服务
 * @author 周舟
 * @date 2020-3-28 10:22:23
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteLiveCompanyService {


    /**
     * 根据主键查询详情（包含统计数据）
     * @param id 主键
     * @return 公司详情
     */
    LiveCompanyDetailDto findDetailById(Long id);

    /**
     * 根据id删除
     * @param id 主键id
     * @return 直播公司
     */
    Integer deleteById(Long id);

    /**
     * 保存直播公司线索收集员信息
     * @param param
     * @return
     */
    Boolean saveClueCollector4Kjj(LiveCompanyClueCollectorParam param);

    /**
     * 获取logo，优先取线索员头像，没有取公司logo
     * @param companyId 公司id
     * @return logo
     */
    String getCluePosterLogo(Long companyId);
}
