package cn.com.duiba.kjy.livecenter.api.dto.customer;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 代理人客户信息
 *
 * @author ZhangJun
 * @date 2021/7/1 9:14 下午
 */
@Data
public class EsAgentCustomerDto implements Serializable {

    private static final long serialVersionUID = 6780271335589252399L;

    /**
     * 客户直播到场次数
     */
    private Integer presentNum;

    /**
     * 总观看时长(秒)
     */
    private Long totalWatchSec;

    /**
     * 平均观看时长(秒)
     */
    private Long avgWatchSec;

    /**
     * 最长观看时长(秒)
     */
    private Long topWatchSec;

    /**
     * 最长观看时间对应的直播间id
     */
    private Long topWatchSecLive;

    /**
     * 代理人id
     */
    private Long agentId;

    /**
     * 客户微信昵称
     */
    private String nickname;

    /**
     * 客户手机号
     */
    private String phone;

    /**
     * 客户id
     */
    private Long liveVisitorId;

    /**
     * 线索价值类型
     */
    private Integer clueValue;

    /**
     * 客户分数
     */
    private Long score;

    /**
     * 跟进机会行为列表
     */
    private List<Integer> chanceTypes;

}
