package cn.com.duiba.kjy.livecenter.api.remoteservice.open;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.open.LiveClueOpenAgentDto;
import cn.com.duiba.kjy.livecenter.api.param.open.LiveClueOpenAgentSearchParam;

import java.util.List;

/**
 * 直播线索统计-合作方代理人信息
 * @author kjj mybatis generator 
 * @date 2020-12-25
 */
@AdvancedFeignClient
public interface RemoteLiveClueOpenAgentService {

    /**
     * 根据条件查询 分页
     * @param param 查询条件
     * @return 直播线索统计-合作方代理人信息集合
     */
    List<LiveClueOpenAgentDto> selectListPage(LiveClueOpenAgentSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveClueOpenAgentSearchParam param);

    /**
     * 根据直播id和代理人id查询代理人信息
     *
     * @param liveId 直播id
     * @param agentId 代理人id
     * @return 代理人信息
     */
    LiveClueOpenAgentDto selectByLiveIdAndAgentId(Long liveId, Long agentId);

    /**
     * 根据直播id和代理人id集合查询代理人信息
     *
     * @param liveId 直播id
     * @param agentIds 代理人id集合
     * @return 代理人信息
     */
    List<LiveClueOpenAgentDto> selectByLiveIdAndAgentIds(Long liveId, List<Long> agentIds);
}