package cn.com.duiba.kjy.livecenter.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 激活定制类型
 *
 * @author xuzhigang
 * @date 2020/12/7 1:59 下午
 **/
@Getter
@AllArgsConstructor
public enum ActivateCustomTypeEnum {
    NORMAL_ACTIVATE(1, "正常激活流程"),

    CUSTOM_ACTIVATE(2, "公众号+工号激活"),

    JOB_NUMBER_ACTIVATE(3, "工号激活"),
    ;

    private Integer type;

    private String desc;

    /**
     * 支持工号激活相关
     * @param type 激活类型
     * @return true-支持 false-不支持
     */
    public static boolean supportJobNumberActivate(Integer type) {
        return Objects.equals(type, CUSTOM_ACTIVATE.getType()) || Objects.equals(type, JOB_NUMBER_ACTIVATE.getType());
    }

    /**
     * 支持工号激活相关
     * @param type 激活类型
     * @return true-不支持 false-支持
     */
    public static boolean notSupportJobNumberActivate(Integer type) {
        return !supportJobNumberActivate(type);
    }
}
