package cn.com.duiba.kjy.livecenter.api.param.customer;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 代理人客户列表分页查询搜索参数
 *
 * @author ZhangJun
 * @date 2021/7/1 2:46 下午
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class EsAgentCustomerSearchParam extends PageQuery {

    private static final long serialVersionUID = 7347045366404235409L;
    /**
     * 代理人id
     */
    private Long agentId;

    /**
     * 价值类型
     *
     * @see cn.com.duiba.kjy.livecenter.api.enums.clue.ClueLevelEnum
     */
    private Integer clueLevel;

    /**
     * 搜索条件值(客户微信昵称/手机号)
     */
    private String searchValue;

    /**
     * 客户类型，枚举，0-普通客户，1-潜在客户
     * @see cn.com.duiba.live.statistics.service.api.enums.customer.CustomerTypeEnum
     */
    private Integer customerType;

    /**
     * 客户行为列表
     * @see cn.com.duiba.live.conf.service.api.enums.clue.LiveVisitorActionEnums
     */
    private List<Integer> actionTypeList;

}
