package cn.com.duiba.kjy.livecenter.api.remoteservice.open;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.open.OpenConfigDto;

/**
 * @author xuzhigang
 * @date 2022/4/13 6:00 下午
 **/
@AdvancedFeignClient
public interface RemoteOpenConfigService {
    /**
     * 根据企业公司id查询配置
     *
     * @param corpCompanyId 企业公司id
     * @return 配置
     */
    OpenConfigDto getByCorpCompanyId(Long corpCompanyId);

    /**
     * 根据直播总公司id查询配置
     *
     * @param liveFirstCompanyId 直播总公司id
     * @return 配置
     */
    OpenConfigDto getByLiveFirstCompanyId(Long liveFirstCompanyId);

    /**
     * 根据配置id查询
     *
     * @param id 配置id
     * @return 配置
     */
    OpenConfigDto getById(Long id);
}
