package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.UserInfo4LoginDto;
import cn.com.duiba.kjy.livecenter.api.param.SyncUserParam;

import java.util.List;

/**
 * Created by dugq on 2020-03-31.
 */
@AdvancedFeignClient
@Deprecated
public interface RemoteOutLiveUserService {

    /**
     * 同步第三方用户信息，并返回直播系统用户信息
     * @param param 第三方用户信息
     * @return 本系统用户信息
     */
    UserInfo4LoginDto getAndSyncUser(SyncUserParam param);

    /**
     * 根据三方业务id 业务类型获取 直播系统用户id
     * @param bizUserId 三方业务用户id
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.BizTypeEnum
     * @return  加密的客集集直播系统用户id
     */
    String getLiveUserIdByBizUserIdAndType(String bizUserId,Integer bizType);


    /**
     * 根据访客用户id  获取客集集系统的邀请人业务id
     * @param visitorLiveUserId  客集集访客在直播系统的liveUserId
     * @param liveId 直播系统的id
     * @return 客集集代理邀请人 在直播系统的tb_live_user.bizUserId(即客集集系统的 tb_users.id)
     */
    String  findInvitorUserId4Kjj(Long visitorLiveUserId,Long liveId);

    /**
     * 批量同步用户
     * @param params
     * @return
     */
    List<UserInfo4LoginDto> batchGetAndSyncUser(List<SyncUserParam> params);
}
