package cn.com.duiba.kjy.paycenter.api.dto.unionpay;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 银联聚分期类型支付
 * @author kjj mybatis generator 
 * @date 2022-10-26
 */
@Data
public class ChargeOrderUnionpayFpsdDto implements Serializable {
     
    private static final long serialVersionUID = 16667528492628640L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 银联聚分期商户id
     */
    private String svcId;

    /**
     * 商户订单号
     */
    private String mchntOrderId;

    /**
     * 交易金额,分为单位
     */
    private Integer transAt;

    /**
     * 终端ip。用户的客户端IP
     */
    private String mchCreateIp;

    /**
     * 交易开始时间，格式为yyyyMMddHHmmss
     */
    private String timeStart;

    /**
     * 订单过期时间，格式为yyyyMMddHHmmss
     */
    private String timeExpired;

    /**
     * 限定银行,商户想指定银行分期支付，则填上该值，取值银行代码简称，多个银行代 码用&分开
     */
    private String suppBankName;

    /**
     * 二维码链接,商户可用此参数自定义去生成二维码后展示出来进行扫码支付
     */
    private String qrNo;

    /**
     * 二维码图片,此参数的值即是根据qrNo生成的可以扫码支付的二维码图片地址
     */
    private String qrImage;

    /**
     * 交易状态,00-交易成功,01-交易处理中,03-交易处理失败
     */
    private String transSt;

    /**
     * 平台订单号,交易成功时返回
     */
    private String orderId;

    /**
     * 支付银行的英文字母简写
     */
    private String bankNm;

    /**
     * 交易完成时间，格式为MMDDhhmmss
     */
    private String traceTime;

    /**
     * 退货笔数
     */
    private Integer refundCnt;

    /**
     * 退货金额
     */
    private Integer refundAt;

    /**
     * 结果码
     */
    private String respCode;

    /**
     * 结果描述
     */
    private String respMsg;

    /**
     * 原交易应答码，transSt为03时可关注该字段返回的具体失败应答
     */
    private String orgnrespcd;

    /**
     * 原交易应答描述,transSt为03时可关注该字段返回的具体失败应答描述
     */
    private String orgnrespmsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}