package cn.com.duiba.kjy.paycenter.api.enums.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 支付处理枚举
 *
 * @author lizhi
 * @date 2020/2/28 11:42 AM
 */
@Getter
@AllArgsConstructor
public enum OrderHandlerTypeEnum {


    CANCEL(1, "订单自动取消"),
    SYNC_PLACE_ORDER(2, "同步下单状态"),
    ;


    /**
     * 类型
     */
    private final Integer type;
    /**
     * 描述
     */
    private final String desc;

    /**
     * 包含所有枚举的map
     */
    private static final Map<Integer, OrderHandlerTypeEnum> ENUM_MAP =
            Collections.unmodifiableMap(
                    Arrays.stream(values()).collect(Collectors.toMap(
                            OrderHandlerTypeEnum::getType, Function.identity()
                    )));


    public static OrderHandlerTypeEnum getByType(Integer handlerType) {
        if (handlerType == null) {
            return null;
        }
        return ENUM_MAP.get(handlerType);
    }

}
