package cn.com.duiba.kjy.paycenter.api.param.wxpay;

import cn.com.duiba.kjy.paycenter.api.param.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 微信类型退款
 * @author kjj mybatis generator 
 * @date 2020-02-28
 */
@ToString(callSuper = true)
@Data
@EqualsAndHashCode(callSuper = true)
public class RefundOrderWxSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15828685582846221L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 微信app_id
     */
    private String appId;

    /**
     * 微信支付分配的商户号
     */
    private String mchId;

    /**
     * 商户订单号
     */
    private String outTradeNo;

    /**
     * 微信支付订单号
     */
    private String transactionId;

    /**
     * 商户退款单号
     */
    private String outRefundNo;

    /**
     * 订单总金额，单位为分，必须大于0
     */
    private Integer totalFee;

    /**
     * 申请退款金额，单位为分，必须大于0
     */
    private Integer refundFee;

    /**
     * 退款原因	
     */
    private String refundDesc;

    /**
     * 退款资金来源，REFUND_SOURCE_UNSETTLED_FUNDS-未结算资金退款，REFUND_SOURCE_RECHARGE_FUNDS-可用余额退款
     */
    private String refundAccount;

    /**
     * 异步接收微信支付退款结果通知的回调地址，通知URL必须为外网可访问的url，不允许带参数
     */
    private String notifyUrl;

    /**
     * 微信退款单号
     */
    private String refundId;

    /**
     * 退款状态,SUCCESS-退款成功、CHANGE-退款异常、REFUNDCLOSE—退款关闭
     */
    private String refundStatus;

    /**
     * 现金支付金额，单位为分
     */
    private Integer cashFee;

    /**
     * 现金退款金额，单位为分
     */
    private Integer cashRefundFee;

    /**
     * 实际退款金额，单位为分，必须大于0
     */
    private Integer settlementRefundFee;

    /**
     * 退款成功时间，格式2017-12-15 09:46:01
     */
    private String refundSuccessTime;

    /**
     * 退款入账账户
     */
    private String refundRecvAccout;

    /**
     * 退款发起来源，API接口、VENDOR_PLATFORM商户平台
     */
    private String refundRequestSource;

    /**
     * 错误代码
     */
    private String errCode;

    /**
     * 错误代码描述
     */
    private String errCodeDes;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}