package cn.com.duiba.kjy.paycenter.api.dto.citic;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 全付通订单
 * @author kjj mybatis generator 
 * @date 2023-01-10
 */
@Data
public class ChargeOrderCiticDto implements Serializable {
     
    private static final long serialVersionUID = 16733217147356233L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 中信全付通商户编号
     */
    private String merNo;

    /**
     * 商户订单号
     */
    private String merOrderNo;

    /**
     * 交易金额,分为单位
     */
    private Integer tranAmt;

    /**
     * 该笔订单允许的最晚付款时间，逾期将关闭交易，默认24小时后的时间。格式为yyyy-MM-dd hh:mm:ss
     */
    private String timeExpire;

    /**
     * 订单有效时长，该字段取值范围：1m~30d。单位 m-分钟，h-小时，d-天。该参数取值不支持小数，不支持1h30m使用多个单位的
     */
    private String timeEffect;

    /**
     * 交易卡类型 01：中信借记卡 02：中信信用卡 03：他行借记卡 04：他行信用卡
     */
    private String cardType;

    /**
     * 交易结果 01：处理中 02：交易成功 03：交易失败 04：交易超时 05：订单已关闭
     */
    private String stt;

    /**
     * 商户流水号
     */
    private String merJnlNo;

    /**
     * 智能收单流水号，统一支付平台流水号
     */
    private String tranJnlNo;

    /**
     * 付款银行名称
     */
    private String payBankName;

    /**
     * 交易完成时间，格式为yyyy-MM-dd hh:mm:ss
     */
    private String tranTime;

    /**
     * 清算日期，格式为yyyyMMdd
     */
    private String settleDate;

    /**
     * 信息标识 AAAAAAA代表成功，XYQRY01订单不存在代表银行处理中（非终态）
     */
    private String retCode;

    /**
     * 返回标识信息描述
     */
    private String retMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}