package cn.com.duiba.kjy.paycenter.api.dto.payment.request.wxpay;

import cn.com.duiba.kjy.paycenter.api.annotation.BizTypeEnumCheck;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 微信企业付款参数
 * @author lizhi
 * @date 2020/4/1 4:50 PM
 */
@Data
public class WxPayCompanyRequest implements Serializable {

    private static final long serialVersionUID = 5636642549994009900L;

    /**
     * 上游调用方的订单号
     */
    @NotBlank(message = "业务方订单号不能为空")
    @Size(max = 25, message = "业务方订单号不能超过25位")
    private String bizTradeNo;

    /**
     * 分配给业务方的类型和bizTradeNo配合使用
     * bizType + bizTradeNo 保证唯一
     * @see cn.com.duiba.kjy.paycenter.api.enums.BizTypeEnum
     */
    @NotNull(message = "bizType不能为空")
    @BizTypeEnumCheck
    private Integer bizType;

    /**
     * 企业付款金额，单位为分
     */
    @NotNull(message = "缺少付款金额")
    @Min(value = 30, message = "最少支付0.3元")
    private Integer amount;

    /**
     * 申请商户号的appid或商户号绑定的appid
     */
    @NotBlank(message = "appId不能为空")
    @Size(max = 128, message = "appId不能超过128位")
    private String appId;

    /**
     * 用户的微信openid
     */
    @NotBlank(message = "openId不能为空")
    @Size(max = 64, message = "openId长度超过64")
    private String openId;

    /**
     * 是否检测用户名，默认不校验
     * @see cn.com.duiba.kjy.paycenter.api.enums.wxpay.WxPayCheckNameEnum
     */
    private String checkName;

    /**
     * 企业付款备注
     * String(100)
     */
    @Size(max = 100, message = "desc长度超过100")
    private String desc;

    /**
     * Ip地址
     * String(32)
     * 非必填
     * 该IP同在商户平台设置的IP白名单中的IP没有关联，该IP可传用户端或者服务端的IP。
     */
    @Size(max = 32, message = "clientIp长度超过32")
    private String clientIp;
}
