package cn.com.duiba.kjy.paycenter.api.param.config;

import cn.com.duiba.kjy.paycenter.api.param.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 支付宝配置表
 * @author kjj mybatis generator 
 * @date 2020-07-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class AliPayConfigSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15942633659495592L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 支付宝应用id
     */
    private String aliAppId;

    /**
     * 请求使用的编码格式
     */
    private String charset;

    /**
     * 1-RSA 2-RSA2 3-md5
     */
    private Byte signType;

    /**
     * 调用的接口版本，固定为：1.0
     */
    private String version;

    /**
     * 公钥
     */
    private String publicKey;

    /**
     * 私钥
     */
    private String privateKey;

    /**
     * 支付渠道
     */
    private String channelType;

    /**
     * 支付渠道名称
     */
    private String channelName;

    /**
     * 0 停止使用 1 待验证 2 可以使用
     */
    private Byte channelStatus;

    /**
     * 支付渠道说明
     */
    private String description;

    /**
     * 渠道手续费，60表示0.6%
     */
    private Integer rate;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}