package cn.com.duiba.kjy.paycenter.api.param.config;

import cn.com.duiba.kjy.paycenter.api.param.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 业务方回调配置
 * @author kjj mybatis generator 
 * @date 2020-02-28
 */
@ToString(callSuper = true)
@Data
@EqualsAndHashCode(callSuper = true)
public class BizCallbackConfigSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 1582868558276669L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务方类型，由支付系统分配给各个业务方
     * @see cn.com.duiba.kjy.paycenter.api.enums.BizTypeEnum
     */
    private Integer bizType;

    /**
     * 回调类型：1-支付回调，2-退款回调
     * @see cn.com.duiba.kjy.paycenter.api.enums.CallbackTypeEnum
     */
    private Integer callbackType;

    /**
     * mq的topic
     */
    private String mqTopic;

    /**
     * mq的tag
     */
    private String mqTag;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}