package cn.com.duiba.kjy.paycenter.api.dto.payment.request.minsheng;

import cn.com.duiba.kjy.paycenter.api.dto.payment.request.BaseChargeRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotBlank;

/**
 * 民生银行支付下单请求
 *
 * @author wangguanhua
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class MinshengPayChargeRequest extends BaseChargeRequest {

    private static final long serialVersionUID = 2795165889458585474L;

    /**
     * 支付成功回调的前端地址
     */
    @NotBlank(message = "支付成功回调的前端地址不能为空")
    private String callbackUrl;

    /**
     * 商品名称（多商品用英文分号隔开，如 AName;BName;CName)
     */
    @NotBlank(message = "商品名称不能为空")
    private String productName;

    /**
     * 商品数量（多商品用英文分号隔开，如 ANum;BNum;CNum)
     */
    @NotBlank(message = "商品数量不能为空")
    private String productNum;

    /**
     * 商品单价（单位：元）（多商品用英文分号隔开，如 Aprice;Bprice;Cprice)
     */
    @NotBlank(message = "商品单价不能为空")
    private String productAmt;

    /**
     * 总价格（单位：元）
     */
    @NotBlank(message = "总价格不能为空")
    private String totalAmt;

    /**
     * 联名登录时传递的 token 值
     */
    @NotBlank(message = "token不能为空")
    private String token;

}
