package cn.com.duiba.kjy.paycenter.api.dto.payment.request.psbc;

import cn.com.duiba.kjy.paycenter.api.dto.payment.request.BaseChargeRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotBlank;

/**
 * 邮储银行支付下单请求
 *
 * @author wangguanhua
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class PsbcPayChargeRequest extends BaseChargeRequest {

    private static final long serialVersionUID = -8559053417876061951L;

    /**
     * 商户号
     */
    @NotBlank(message = "商户号不能为空")
    private String merchantCode;

    /**
     * 服务商页订单详情页url（用于支付成功页跳转）
     */
    @NotBlank(message = "服务商页订单详情页url不能为空")
    private String backLink;

}
