package cn.com.duiba.kjy.paycenter.api.dto.payment.response;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 支付收单回执
 * @author lizhi
 * @date 2020/2/28 11:34 AM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public abstract class BaseChargeResponse extends BaseResponse {

    private static final long serialVersionUID = -4191338585032542751L;

    /**
     * 支付订单号(商户订单号)
     */
    private String outTradeNo;

    /**
     * 分配给业务方的类型和bizOrderNo配合使用
     * bizType + bizOrderNo 保证唯一
     * @see cn.com.duiba.kjy.paycenter.api.enums.BizTypeEnum
     */
    private Integer bizType;

    /**
     * 上游调用方的订单号
     */
    private String bizOrderNo;

    /**
     * 设置错误信息
     * @param chargeResponse 支付收单回执
     * @param errorMsg 错误信息
     * @return 支付收单回执
     */
    public static  <T extends BaseChargeResponse> T buildErrorMsg(T chargeResponse, String errorMsg) {
        if (chargeResponse == null || errorMsg == null) {
            return chargeResponse;
        }
        chargeResponse.setErrorMsg(errorMsg);
        return chargeResponse;
    }
}
