package cn.com.duiba.kjy.paycenter.api.dto.payment.request;

import cn.com.duiba.kjy.paycenter.api.annotation.BizTypeEnumCheck;
import cn.com.duiba.kjy.paycenter.api.annotation.ChannelTypeEnumCheck;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;

/**
 * 支付请求的基本类
 * @author lizhi
 * @date 2020/2/28 11:37 AM
 */
@Data
public class BaseChargeRequest implements Serializable {

    private static final long serialVersionUID = 3086092861588020891L;

    /**
     * 支付金额，单位为分
     */
    @NotNull(message = "缺少支付金额")
    @Min(value = 1, message = "最少支付一分钱")
    private Integer amount;

    /**
     * 上游调用方的订单号
     */
    @NotBlank(message = "业务方订单号不能为空")
    @Size(max = 25, message = "业务方订单号不能超过25位")
    private String bizOrderNo;

    /**
     * 分配给业务方的类型和bizOrderNo配合使用
     * bizType + bizOrderNo 保证唯一
     * @see cn.com.duiba.kjy.paycenter.api.enums.BizTypeEnum
     */
    @NotNull(message = "bizType不能为空")
    @BizTypeEnumCheck
    private Integer bizType;

    /**
     * 支付渠道
     * @see cn.com.duiba.kjy.paycenter.api.enums.ChannelTypeEnum
     */
    @NotNull(message = "channelType不能为空")
    @ChannelTypeEnumCheck
    private String channelType;

    /**
     * 支付渠道应用ID
     */
    @Size(max = 32, message = "支付渠道应用ID不能超过25位")
    private String appId;

    /**
     * 业务方查询需要的信息
     * 创建订单时自行放入，格式不做要求，业务方自行解析
     */
    @Size(max = 1024, message = "metadata长度超出1024")
    private String metadata;

    /**
     * 交易结束时间
     * 止付时间 必须要大于1分钟
     */
    private Date timeExpire;

    /**
     * 是否限制信用卡支付
     */
    private Boolean limitCreditPay;

    /**
     * 下单时间 没有就取当前时间
     */
    private Date orderTime;

    public Date getOrderTime() {
        if (this.orderTime == null) {
            return new Date();
        }
        return this.orderTime;
    }
}
