package cn.com.duiba.kjy.paycenter.api.dto.payment.request.boc;

import java.io.Serializable;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import lombok.Data;

/**
 * BOC银行退款请求参数
 * @author yangyukang
 * @date 2025/1/27
 */
@Data
public class BocRefundRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 原支付订单号(必填)
     */
    @NotBlank(message = "原支付订单号不能为空")
    @Size(max = 64, message = "原支付订单号长度不能超过64位")
    private String orderNo;

    /**
     * 退款金额，单位为分(必填)
     */
    @NotNull(message = "退款金额不能为空")
    @Min(value = 1, message = "退款金额必须大于0")
    private Long refundAmount;

    /**
     * 商户退款流水号(必填)
     * 商户系统产生的退款交易流水号，用于标识本次退款
     */
    @NotBlank(message = "商户退款流水号不能为空")
    @Size(max = 64, message = "商户退款流水号长度不能超过64位")
    private String mRefundSeq;
}
