package cn.com.duiba.kjy.paycenter.api.enums.wxpay;

import java.util.HashMap;
import java.util.Map;

/**
 * 企业付款到零钱订单状态
 * @author lizhi
 * @date 2020/4/1 7:28 PM
 */
public enum WxPayCompanyPayStatusEnum {

    INIT(0, "初始化状态"),
    UNKNOWN(1,"调用微信发生错误，请用原单号重试"),
    //中间状态：SYSTEMERROR、SEND_FAILED、FATAL_ERROR、新增错误码（文档提示，可能会新增错误码）
    PROCESSING(2,"微信中间状态，具体根据错误码来处理"),
    SUCCESS(3, "转账成功"),
    FAILED(4, "转账失败"),
    ;

    private Integer code;
    private String desc;

    WxPayCompanyPayStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, WxPayCompanyPayStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(WxPayCompanyPayStatusEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static WxPayCompanyPayStatusEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
