package cn.com.duiba.kjy.paycenter.api.param.alipay;

import cn.com.duiba.kjy.paycenter.api.param.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 支付宝支付订单表
 * @author kjj mybatis generator 
 * @date 2020-07-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ChargeOrderAliPaySearchParam extends PageQuery {
     
    private static final long serialVersionUID = 1594265984560696L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 对一笔交易的具体描述信息。如果是多种商品，请将商品描述字符串累加传给body
     */
    private String body;

    /**
     * 商品的标题/交易标题/订单标题/订单关键字等
     */
    private String subject;

    /**
     * 商户网站唯一订单号
     */
    private String outTradeNo;

    /**
     * 绝对超时时间，格式为yyyy-MM-dd HH:mm
     */
    private String timeExpire;

    /**
     * 订单总金额，单位分
     */
    private Integer totalAmount;

    /**
     * 销售产品码，商家和支付宝签约的产品码
     */
    private String productCode;

    /**
     * 该交易在支付宝系统中的交易流水号
     */
    private String tradeNo;

    /**
     * 收款支付宝账号对应的支付宝唯一用户号，以2088开头的纯16位数字
     */
    private String aliSellerId;

    /**
     * 商户原始订单号，最大长度限制32位
     */
    private String merchantOrderNo;

    /**
     * 买家支付宝账号对应的支付宝唯一用户号。以2088开头的纯16位数字
     */
    private String buyerId;

    /**
     * 买家支付宝账号
     */
    private String buyerLogonId;

    /**
     * 卖家支付宝账号
     */
    private String aliSellerEmail;

    /**
     * 交易创建:WAIT_BUYER_PAY,未付款交易超时关闭，或支付完成后全额退款:TRADE_CLOSED，交易支付成功：TRADE_SUCCESS，交易结束，不可退款：TRADE_FINISHED
     */
    private String tradeStatus;

    /**
     * 商家在交易中实际收到的款项，单位为分
     */
    private Integer receiptAmount;

    /**
     * 用户在交易中支付的可开发票的金额，单位为分
     */
    private Integer invoiceAmount;

    /**
     * 用户在交易中支付的金额，单位为分
     */
    private Integer buyerPayAmount;

    /**
     * 支付成功的各个渠道金额信息
     */
    private String fundBillList;

    /**
     * 本交易支付时所使用的所有优惠券信息
     */
    private String voucherDetailList;

    /**
     * 交易付款时间
     */
    private Date gmtPayment;

    /**
     * 错误代码
     */
    private String errCode;

    /**
     * 错误代码描述
     */
    private String errMsg;

    /**
     * 子错误代码
     */
    private String subErrCode;

    /**
     * 子错误代码描述
     */
    private String subErrMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}