package cn.com.duiba.kjy.paycenter.api.dto.payment.request;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 退款请求的基本类
 * @author lizhi
 * @date 2020/2/28 4:08 PM
 */
@Data
public class BaseRefundRequest implements Serializable {

    private static final long serialVersionUID = 3196230634518904056L;

    /**
     * 需要退款的金额，必须小于支付金额
     * 单位为分
     */
    @NotNull(message = "退款金额不能为空")
    @Min(value = 1, message = "最少退款一分钱")
    private Integer applyRefundAmount;

    /**
     * 上游调用方的退款单号，为空的话，默认将业务订单号加上_RFD
     */
    @Size(max = 50, message = "退款单号不能超过50位")
    private String bizRefundNo;

    /**
     * 以下字段三选一
     * 1. 支付订单号(商户订单号) 支付订单
     * 2. 第三方支付流水号
     * 3. 业务方订单号以及业务方类型
     */

    /**
     * 支付订单号(商户订单号) 支付订单
     */
    private String outTradeNo;

    /**
     * 第三方支付流水号
     */
    private String transactionNo;

    /**
     * 业务方的订单号
     */
    private String bizOrderNo;

    /**
     * 业务方类型
     * {@link cn.com.duiba.kjy.paycenter.api.enums.BizTypeEnum}
     */
    private Integer bizType;

    /**
     * 退款原因
     */
    @Size(max = 80, message = "退款原因长度超过128")
    private String refundDesc;
}
