package cn.com.duiba.kjy.paycenter.api.dto.payment.request.unionpay;

import cn.com.duiba.kjy.paycenter.api.dto.payment.request.BaseChargeRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.Size;

/**
 * 银联趣分期 下单请求
 *
 * @author xuzhigang
 * @date 2022/10/26 3:03 下午
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class UnionPayFpsdChargeRequest extends BaseChargeRequest {
    private static final long serialVersionUID = -1545202597347996510L;

    /**
     * 终端ip 公网ip非内网ip
     */
    @Size(min = 7, max = 15, message = "ip长度异常")
    private String mchCreateIp;

    /**
     * 商品详细信息
     */
    @Size(max = 255, message = "商品详细信息长度超过255")
    private String body;

    /**
     * 限定银行,商户想指定银行分期支付，则填上该值，取值银行代码简称，多个银行代码用&分开
     */
    private String suppBankName;

    /**
     * 商户指定分期期数，支持上送多个期数，例 3&6&9&12
     */
    private String limitNum;
}
