package cn.com.duiba.kjy.paycenter.api.dto.payment.response.psbc;

import lombok.Data;

import java.io.Serializable;

/**
 * 邮储请求报文结构
 *
 * @author wangguanhua
 */
@Data
public class PsbcCommonResponse implements Serializable {

    private static final long serialVersionUID = 49260547063520247L;

    /**
     * 加密后的响应报文
     */
    private String response;
    /**
     * 数字签名
     *
     * <p>服务开发平台响应报文签名规则:对response + encryptKey + accessToken 组成的字符串使用服开私钥sm2加密后作为签名signature。</p>
     */
    private String signature;

    /**
     * 请求方的访问令牌
     *
     * <p>为空时取空字符串。</p>
     */
    private String accessToken;

    /**
     * 报文sm4加密密钥,使用sm2加密后的密文
     */
    private String encryptKey;

}

