package cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay;

import lombok.Data;

import java.io.Serializable;

/**
 * 唤起微信支付的加密信息
 * @author lizhi
 * @date 2021/11/10 4:37 下午
 */
@Data
public class WxPaySignResponse implements Serializable {

    private static final long serialVersionUID = 7199999250155465323L;

    /**
     * 微信生成的预支付回话标识，用于后续接口调用中使用，该值有效期为2小时
     */
    private String prepayId;

    /**
     * 时间戳精确到秒
     */
    private Long timeStamp;

    /**
     * 随机字符串
     */
    private String nonceStr;

    /**
     * 公众号id
     */
    private String appId;

    /**
     * 签名类型需要和下单一致
     */
    private String signType;

    /**
     * 签名
     */
    private String paySign;
}
