package cn.com.duiba.kjy.paycenter.api.remoteservice.config;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.paycenter.api.dto.config.BizCallbackConfigDto;
import cn.com.duiba.kjy.paycenter.api.param.PageQuery;

import java.util.List;

/**
 * 业务方回调配置
 * @author xuzhigang
 * @date 2021/6/17 2:52 下午
 */
@AdvancedFeignClient
public interface RemoteBizCallbackConfigService {

    /**
     * 分页查询
     * @param pageQuery 查询条件
     * @return 业务方回调配置集合
     */
    List<BizCallbackConfigDto> selectPage(PageQuery pageQuery);

    /**
     * 根据条件,查询记录的总记录数
     * @return 符合条件的记录数
     */
    Long selectCount();

    /**
     * 根据业务id批量查询
     * @param bizTypes 业务id
     * @return 回调配置集合
     */
    List<BizCallbackConfigDto> selectListByBizTypes(List<Integer> bizTypes);

    /**
     * 根据业务类型及回调类型查询
     * @param bizType 业务方类型，由支付系统分配给各个业务方
     * @see cn.com.duiba.kjy.paycenter.api.enums.BizTypeEnum
     * @param callbackType 回调类型
     * @see cn.com.duiba.kjy.paycenter.api.enums.CallbackTypeEnum
     * @return 业务方回调配置
     */
    BizCallbackConfigDto selectByBizAndCallbackType(Integer bizType, Integer callbackType);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 业务方回调配置
     */
    BizCallbackConfigDto selectById(Long id);

    /**
     * 新增/更新
     * @param dto 业务方回调配置
     * @return 执行结果
     */
    int saveOrUpdate(BizCallbackConfigDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
