package cn.com.duiba.kjy.paycenter.api.validator;


import cn.com.duiba.kjy.paycenter.api.annotation.ChannelTypeEnumCheck;
import cn.com.duiba.kjy.paycenter.api.enums.ChannelTypeEnum;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * @author lizhi
 * @date 2020/03/03
 */
public class ChannelTypeEnumCheckConstraintValidator implements ConstraintValidator<ChannelTypeEnumCheck, String> {

    private String message;

    @Override
    public void initialize(ChannelTypeEnumCheck constraintAnnotation) {
        this.message = constraintAnnotation.message();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (ChannelTypeEnum.isActive(value)) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        ConstraintValidatorContext.ConstraintViolationBuilder builder =
                context.buildConstraintViolationWithTemplate(message);
        builder.addConstraintViolation();
        return false;
    }
}
