package cn.com.duiba.kjy.paycenter.api.dto.config;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 邮储银行商户配置表
 * @author kjj mybatis generator 
 * @date 2024-08-08
 */
@Data
public class PsbcpayMchConfDto implements Serializable {
     
    private static final long serialVersionUID = 17231107281589722L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 商户号
     */
    private String merchantCode;

    /**
     * 商户通知地址（回调接口，用于修改订单状态）
     */
    private String merchantCallbackUrl;

    /**
     * 三方标识（服务商首字母大写缩写,例：蓝色兄弟：‘LSXD’）
     */
    private String psbcmcc;

    /**
     * 合作方编号
     */
    private String merchantId;

    /**
     * 门户首页分配给商户的 APP_ID
     */
    private String appId;

    /**
     * 服开公钥
     */
    private String sopPublicKey;

    /**
     * 合作方公钥
     */
    private String merchantPublicKey;

    /**
     * 合作方私钥
     */
    private String merchantPrivateKey;

    /**
     * 收银台签名密钥
     */
    private String plainTextSecret;
}