package cn.com.duiba.kjy.paycenter.api.dto.payment.request.alipay;

import cn.com.duiba.kjy.paycenter.api.dto.payment.request.BaseChargeRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * @author xuzhigang
 * @date 2024/5/7 16:01
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class AliPayFaceToFaceJsApiRequest extends BaseChargeRequest {
    private static final long serialVersionUID = 4279392021897431799L;

    /**
     * 订单标题。
     * 注意：不可使用特殊字符，如 /，=，& 等。
     */
    @NotBlank(message = "商品标题不能为空")
    @Size(max = 128, message = "商品标题长度超过128")
    private String subject;

    /**
     * 买家支付宝用户ID
     * 2088开头的16位纯数字
     */
    @NotBlank(message = "买家支付宝用户ID不能为空")
    @Size(max = 28, message = "买家支付宝用户id长度超过28")
    private String buyerId;

    /**
     * 订单附加信息。(非必填)
     * 如果请求时传递了该参数，将在异步通知、对账单中原样返回，同时会在商户和用户的pc账单详情中作为交易描述展示
     */
    @Size(max = 128, message = "订单附加信息长度超过128")
    private String body;

    /**
     * 订单相对超时时间。从交易创建时间开始计算。（非必填）
     * 该笔订单允许的最晚付款时间，逾期将关闭交易。取值范围：1m～15d。m-分钟，h-小时，d-天，1c-当天（1c-当天的情况下，无论交易何时创建，都在0点关闭）。 该参数数值不接受小数点， 如 1.5h，可转换为 90m。
     * 当面付场景默认值为3h。
     * 注：time_expire和timeout_express两者只需传入一个或者都不传，如果两者都传，优先使用time_expire。
     */
    @Size(max = 6, message = "订单相对超时时间长度超过6")
    private String timeoutExpress;

    /**
     * 订单优惠标记
     */
    @Size(max = 32, message = "优惠标记长度超过32")
    private String promoTag;
}
