package cn.com.duiba.kjy.paycenter.api.dto.payment.request.citic;

import cn.com.duiba.kjy.paycenter.api.dto.payment.request.BaseChargeRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * 中信全付通支付下单请求
 *
 * @author xuzhigang
 * @date 2023/1/11 5:14 下午
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CiticPayChargeRequest extends BaseChargeRequest {
    private static final long serialVersionUID = 226804330249994820L;

    /**
     * 中信业务种类
     * {@link cn.com.duiba.kjy.paycenter.api.enums.citic.CiticBizTypeEnum}
     */
    @NotBlank(message = "中信业务种类不能为空")
    private String citicBizType;

    /**
     * 互认协议号
     * 若输入该字段，我行将通过此字段判断该客户是否在此商户支付过，是再次支付时将免登陆直接进入订单页；
     * 若不输此字段将进入不互认流程，每次都需客户录入手机号和密码；
     * 可以使用unionId(28位)作为用户唯一标识
     */
    @Size(max = 32, message = "互认协议号不能超过32位")
    private String trdCstNo;
}
