package cn.com.duiba.kjy.paycenter.api.dto.payment.response.cgb;

import cn.com.duiba.kjy.paycenter.api.dto.payment.response.BaseChargeResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author nongfu
 * @Date 2024/10/14 10:38
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CgbPayChargeResponse extends BaseChargeResponse implements Serializable {

    /**
     * 行方交易订单号
     */
    private String tradeOrderNo;
    /**
     * 商户订单号
     */
    private String merchantOrderNo;
    /**
     * 银行订单号
     */
    private String bankOrderNo;
    /**
     * 订单状态(00-待付款,01-待发货,02-已发货,03-已完成,04-退款中,05-发货失败,06-发货异常,07-已关闭)
     */
    private String orderStatus;

    /**
     * 0000- 成功
     */
    private String errorCode;
    /**
     * 错误信息
     */
    private String errorMsg;

    public boolean requestSuccess() {
        return "0000".equals(errorCode);
    }
}
