package cn.com.duiba.kjy.paycenter.api.dto.payment.response;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * 退款回调结果
 * @author lizhi
 * @date 2020/3/2 4:58 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseRefundNotifyResponse extends BaseResponse {

    private static final long serialVersionUID = -7121755093824274413L;

    /**
     * 退款是否成功
     */
    private boolean refundSuccess;

    /**
     * 分配给业务方的类型和bizOrderNo配合使用
     * bizType + bizOrderNo 保证唯一
     * @see cn.com.duiba.kjy.paycenter.api.enums.BizTypeEnum
     */
    private Integer bizType;

    /**
     * 业务方的退款订单id
     */
    private String bizRefundNo;

    /**
     * 退款订单号
     */
    private String outRefundNo;

    /**
     * 上游调用方的订单号
     */
    private String bizOrderNo;

    /**
     * 支付订单流水号
     */
    private String outTradeNo;

    /**
     * 第三方交易流水号
     */
    private String transactionNo;

    /**
     * 第三方退款流水号
     */
    private String refundNo;

    /**
     * 退款成功时间
     */
    private Date refundTime;

    /**
     * 设置错误信息
     * @param notifyResponse 退款回调回执
     * @param errorMsg 错误信息
     * @return 退款回调回执
     */
    public static  <T extends BaseRefundNotifyResponse> T buildErrorMsg(T notifyResponse, String errorMsg) {
        if (notifyResponse == null || errorMsg == null) {
            return notifyResponse;
        }
        notifyResponse.setErrorMsg(errorMsg);
        notifyResponse.setRefundSuccess(false);
        return notifyResponse;
    }
}
