package cn.com.duiba.kjy.paycenter.api.dto.payment.response;

import cn.com.duiba.kjy.paycenter.api.enums.ResponseCodeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2020/2/29 8:49 AM
 */
@Data
public class BaseResponse implements Serializable {

    private static final long serialVersionUID = 8571677299301122038L;

    /**
     * 返回状态码（SUCCESS/FAIL）
     */
    private String code;

    /**
     * 错误信息描述
     */
    private String message;

    public boolean isSuccess() {
        return ResponseCodeEnum.SUCCESS.getCode().equals(code);
    }

    protected void setErrorMsg(String errorMsg) {
        this.setCode(ResponseCodeEnum.FAIL.getCode());
        this.setMessage(errorMsg);
    }
}
