package cn.com.duiba.kjy.paycenter.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/3/5 3:31 PM
 */
@Getter
@AllArgsConstructor
public enum CallbackTypeEnum {

    /**
     * 支付回调
     */
    CHARGE(1, "支付回调"),

    /**
     * 退款回调
     */
    REFUND(2, "退款回调"),

    /**
     * 企业付款到领取结果
     */
    WX_COM_RESULT(3, "企业付款到领取结果"),

    /**
     * 微信小程序下单回调
     */
    WX_LITE_CHARGE_RESULT(4, "微信小程序下单回调"),

    /**
     * 微信公众号下单回调
     */
    WX_MP_CHARGE_RESULT(5, "微信公众号下单回调"),

    /**
     * 支付宝手机网站支付2.0下单回调
     */
    ALIPAY_WAP_CHARGE_RESULT(6, "支付宝手机网站支付2.0下单回调"),

    /**
     * 银联趣分期下单回调
     */
    UNION_PAY_FPSD_RESULT(7, "银联趣分期下单回调"),

    /**
     * 中信下单回调
     */
    CITIC_PAY_RESULT(8, "中信下单回调"),
    ;

    private final Integer code;

    private final String desc;

    private static final Map<Integer, CallbackTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CallbackTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getCode(), typeEnum);
        }
    }

    public static CallbackTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
