package cn.com.duiba.kjy.paycenter.api.enums.citic;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 中信交易结果枚举
 *
 * @author xuzhigang
 * @date 2023/1/13 1:47 下午
 **/
@Getter
@AllArgsConstructor
public enum CiticTransSttEnum {
    PROCESSING("01", "处理中"),

    SUCCESS("02", "交易成功"),

    FAIL("03", "交易失败"),

    OVERTIME("04", "超时"),

    CLOSED("05", "订单已关闭")
    ;

    private final String stt;

    private final String desc;

    private static final Map<String, CiticTransSttEnum> map = new HashMap<>();

    static {
        for (CiticTransSttEnum value : values()) {
            map.put(value.getStt(), value);
        }
    }

    public static CiticTransSttEnum getByStt(String stt) {
        return map.get(stt);
    }
}
