package cn.com.duiba.kjy.paycenter.api.enums.unionpay;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author xuzhigang
 * @date 2022/10/28 11:37 上午
 **/
@Getter
@AllArgsConstructor
public enum UnionPayFpsdTransStEnum {
    SUCCESS("00", "交易成功"),

    PROCESSING("01", "交易处理中"),

    ORGN_FAIL("02", "原交易失败，无需处理"),

    FAIL("03","交易处理失败"),

    NOT_PAY("04", "交易未支付"),

    REFUND("07", "产生退货"),

    ALL_REFUND("08", "已全部退货"),

    TOKEN_FAIL("12", "token申请失败"),

    ;


    private final String code;

    private final String desc;

    private static final Map<String, UnionPayFpsdTransStEnum> map = new HashMap<>();

    static {
        for (UnionPayFpsdTransStEnum value : values()) {
            map.put(value.getCode(), value);
        }
    }

    public static UnionPayFpsdTransStEnum getByCode(String code) {
        return map.get(code);
    }
}
