package cn.com.duiba.kjy.paycenter.api.param.alipay;

import cn.com.duiba.kjy.paycenter.api.param.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 支付宝退款订单表
 * @author kjj mybatis generator 
 * @date 2020-07-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class RefundOrderAliPaySearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15943731925121254L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 商户网站唯一订单号
     */
    private String outTradeNo;

    /**
     * 退款订单号
     */
    private String outRefundNo;

    /**
     * 标识一次退款请求，同一笔交易多次退款需要保证唯一，如需部分退款，则此参数必传,用支付单号加退款前缀
     */
    private String outRequestNo;

    /**
     * 该交易在支付宝系统中的交易流水号
     */
    private String tradeNo;

    /**
     * 订单总金额，单位为分，必须大于0
     */
    private Integer chargeAmount;

    /**
     * 订单总金额，单位分
     */
    private Integer refundFee;

    /**
     * 退款币种信息
     */
    private String refundCurrency;

    /**
     * 退款原因的说明
     */
    private String refundReason;

    /**
     * 退款使用的资金渠道
     */
    private String refundDetailItemList;

    /**
     * 用户的登录id
     */
    private String buyerLogonId;

    /**
     * 买家在支付宝的用户id
     */
    private String buyerUserId;

    /**
     * 本次退款是否发生了资金变化
     */
    private String fundChange;

    /**
     * 退款支付时间
     */
    private Date gmtRefundPay;

    /**
     * 退款状态,SUCCESS-退款成功、CHANGE-退款异常、REFUNDCLOSE—退款关闭
     */
    private String refundStatus;

    /**
     * 错误代码
     */
    private String errCode;

    /**
     * 错误代码描述
     */
    private String errMsg;

    /**
     * 子错误代码
     */
    private String subErrCode;

    /**
     * 子错误代码描述
     */
    private String subErrMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}