package cn.com.duiba.kjy.paycenter.api.remoteservice.config;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.paycenter.api.dto.config.PayMarketingConfDto;
import cn.com.duiba.kjy.paycenter.api.param.PageQuery;

import java.util.List;

/**
 * 支付营销配置
 * @author kjj mybatis generator 
 * @date 2021-06-16
 */
@AdvancedFeignClient
public interface RemotePayMarketingConfService {

    /**
     * 分页查询
     * @param pageQuery 查询条件
     * @return 支付营销配置集合
     */
    List<PayMarketingConfDto> selectPage(PageQuery pageQuery);

    /**
     * 根据条件,查询记录的总记录数
     * @return 符合条件的记录数
     */
    Long selectCount();

    /**
     * 根据主键查询
     * @param id 主键
     * @return 支付营销配置
     */
    PayMarketingConfDto selectById(Long id);

    /**
     * 新增或更新
     * @param dto 支付营销配置
     * @return 执行结果
     */
    int saveOrUpdate(PayMarketingConfDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}