package cn.com.duiba.kjy.taskcenter.api.constants;

/**
 * @author lizhi
 * @date 2020/3/30 2:34 PM
 */
public enum LiveCenterRedisKeyFactory {

    KC004("直播缓存"),
    KC017("直播间纬度统计锁"),
    KC027("直播间观看人数统计"),
    KC056("直播到场标识，缓存"),
    KC105("直播团队平均邀请/到场统计频次缓存"),
    KC121("直播代理人公司团队关联关系-代理人id、公司id维度缓存"),
    KC125("访客在线时长记录缓存"),
    KC126("访客总观看时长统计"),
    KC127("观看人数>心跳时间人数"),
    KC128("观看时长>2min人数"),
    KC129("观看时长>10min人数"),
    KC130("观看时长>30min人数"),
    KC140("代理人客户顶部统计信息redis缓存"),
    ;

    private static final String SPACE = "KjyLiveCenter";
    private static final String SEPARATOR = "_";

    String desc;

    LiveCenterRedisKeyFactory(String desc){
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    @Override
    public String toString(){
        return SPACE +SEPARATOR+ this.name();
    }
}
