package cn.com.duiba.kjy.taskcenter.api.constants;

/**
 * @author lizhi
 * @date 2020/3/30 2:34 PM
 */
public enum LiveClueCenterRedisKeyFactory {

    LC010("直播抽奖es状态标识"),
    LC005("绑定过的用户信息，缓存"),
    LC016("用户生日信息 直播、用户纬度 缓存"),
    LC021("邀请客户列表"),
    LC166("用户翻牌统计数据 redis缓存"),
    LC181("翻牌集字-用户记录"),
    ;

    private static final String SPACE = "LiveClueCenter";
    private static final String SEPARATOR = "_";

    String desc;

    LiveClueCenterRedisKeyFactory(String desc){
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    @Override
    public String toString(){
        return SPACE +SEPARATOR+ this.name();
    }
}
