package cn.com.duiba.kjy.taskcenter.api.constants;

/**
 * @author lizhi
 * @date 2021/1/7 4:21 下午
 */
public enum RedisKeyCopyOfClueCenterFactory {

    LC184("秒杀商品-用户下单/取消下单分布式锁"),
    LC185("秒杀商品-用户数据缓存"),
    LC197("用户优惠券记录"),
    ;

    private static final String SPACE = "LiveClueCenter";
    private static final String SEPARATOR = "_";

    String desc;

    RedisKeyCopyOfClueCenterFactory(String desc){
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    @Override
    public String toString(){
        return SPACE +SEPARATOR+ this.name();
    }
}
