package cn.com.duiba.kjy.taskcenter.api.constants;

/**
 * @author zhanghuifeng
 * date 2019-04-30-17:02
 */
public enum RedisKeyFactory {

    K002("公众号信息缓存"),

    K008("公众号缓存"),

    K010("消息配置根据oaId_mark 的缓存"),
    K011("消息配置根据mark的缓存"),
    K012("种草素材午间推送,oaid对应的查看更多链接缓存"),
    K013("种草素材早报推送,oaid对应的查看更多链接缓存"),

    K018("周报代理人排名"),
    K019("用户类型推送延时缓存"),
    K020("种草素材推送,oaid对应的推送内容缓存"),
    K021("今日热文推送,oaid对应的推送内容缓存"),
    K022("晚安心语推送,oaid对应的推送内容缓存"),
    K023("早报推送,oaid对应的早报推送内容缓存"),
    K024("早报推送,oaid对应的种草素材推送内容缓存"),
    K025("日更海报推送,oaid对应的类型是否有回复语缓存"),

    K030("直播预热抽奖任务，分布式锁"),
    K031("直播预热抽奖任务执行完成，缓存"),

    K072("是否开启免打扰缓存"),

    K107("用户版本信息缓存"),
    K111("节日贺卡访问记录"),

    K121("代理人已推唤醒文案Id缓存"),
    K122("今日唤醒推送的代理人ids"),

    K124("开播提醒推送直播用户ids"),

    K125("直播纬度代理人准客户数据"),


    K127("每日晚安心语推送情况缓存"),
    K128("每日种草素材推送情况缓存"),
    K129("每日热文推送情况缓存"),
    K130("每日早报推送情况缓存"),
    K140("直播团队榜,以代理人平均邀请排序,直播间纬度,zset的key"),
    K141("直播团队榜,以代理人平均邀请排序,团队纬度rediskey"),
    K142("直播团队榜,团队的数量rediskey"),
    K143("新手教程视频已读缓存"),

    K149("直播火眼代理人直接邀请数zset的key"),
    K150("直播火眼代理人邀请数zset的key"),
    K151("直播火眼代理人避免重复统计rediskey"),
    K152("直播火眼直播前邀请统计避免重复统计rediskey"),
    K153("直播火眼直播观看避免重复统计rediskey"),
    K154("直播火眼直播观看统计redis锁"),
    K155("直播进行中线索统计,直播间纬度redis锁"),
    K156("直播结束代理人线索数量统计redis缓存"),
    K157("直播进行中代理人线索统计,直播间纬度redis锁"),
    K158("直播进行中最高在线人数Redis缓存"),

    K160("直播个人榜榜单zset的key"),
    K161("直播代理人个人榜单，邀请 rediskey"),
    K162("直播代理人个人榜单，到场 rediskey"),
    K163("直播代理人个人榜单，邀请 Top One"),
    K164("直播代理人个人榜单，到场 Top One"),

    K165("直播团队榜榜单zset的key"),
    K166("直播代理人团队榜单，邀请 rediskey"),
    K167("直播代理人团队榜单，到场 rediskey"),
    K168("直播代理人团队榜单，邀请 Top One"),
    K169("直播代理人团队榜单，到场 Top One"),

    K170("直播队内榜单zset的key"),
    K171("直播代理人队内榜单，邀请 rediskey"),
    K172("直播代理人队内榜单，到场 rediskey"),
    K173("直播中代理人线索统计"),
    K177("直播火眼数据统计,分享活动,助力人数缓存"),
    K178("直播火眼数据统计,分享活动,参与人数缓存"),
    K179("直播结束后,用户统计数据"),

    K180("直播间对应预约人数rediskey"),
    K181("直播间异步生成奖品签收记录数据 redis锁"),
    K182("直播间异步生成奖品签收记录confId同步完成标志"),

    K183("黄金宝典同步 redis锁"),
    K184("黄金宝典同步 accessToken缓存"),
    K185("黄金宝典同步 accessToken生成锁"),
    K186("发奖小程序已推送提醒代理人设置中奖人数活动 缓存数据"),
    K187("(新版)发奖小程序已推送提醒代理人设置中奖人数活动 缓存数据"),
    K188("删除团队 分布式锁"),
    K189("线索员下用户数据迁移 分布式锁"),

    K190("准客户-代理人准客户 redisKey"),

    K191("直播秒杀预告-已推送用户"),
    K195("代理人客户第一次邀请记录缓存"),

    K196("企业版-根据公司授权到期时间批量更新代理人会员到期时间"),

    K197("邀请关系结束前推送缓存"),
    K198("邀请关系每日删除数量缓存"),
    ;

    private static final String SPACE = "TaskCenter";
    private static final String SEPARATOR = "_";

    String desc;

    RedisKeyFactory(String desc){
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    @Override
    public String toString(){
        return SPACE +SEPARATOR+ this.name();
    }
}
