package cn.com.duiba.kjy.taskcenter.api.dto;

import lombok.Data;

import java.util.Date;

/**
 * 企业版-公司授权到期时间 -> 同步代理人有效期，消费者bean
 *
 * @author ZhangJun
 * @date 2021/11/3 5:07 下午
 */
@Data
public class CorpAuthExpiredDateConsumerDto {

    /**
     * 需要同步的公司id
     * tb_corp_company.id
     */
    private Long companyId;

    /**
     * 起始员工id
     * 不包含在内
     * tb_corp_company_employee.id
     * default null
     */
    private Long startEmployeeId;

    /**
     * 结束员工id
     * 不包含在内
     * tb_corp_company_employee.id
     * default null
     */
    private Long endEmployeeId;

    /**
     * 上一次公司授权有效期
     * not null
     */
    private Date lastCompanyAuthDate;

}
