package cn.com.duiba.kjy.taskcenter.api.constants;

/**
 * @author guoxuebiao
 * @date 2021/9/15 10:27 上午
 */
public enum RedisKeyFactoryCopyOfLiveNormal {

    LNS001("直播助力人数"),
    LNS002("黑名单源头用户信息缓存"),
    LNS003("美颜配置新增或修改 分布式锁"),
    LNS004("引导视频-访客记录新增 分布式锁"),
    LNS005("定制公司团队缓存"),
    LNS006("保存直播推送信息 分布式锁"),
    LNS007("引导视频新增 分布式锁"),
    LNS008("架构名单新增或修改 分布式锁"),
    LNS009("直播用户抽奖码数量缓存"),
    LNS010("抽奖码redisKey"),
    LNS011("抽奖码自增ID"),
    LNS012("OTO-投放池客户"),
    LNS013("OTO-b类销售可看A类客户范围"),
    ;

    private static final String SPACE = "LiveNormalService";
    private static final String SEPARATOR = "_";

    String desc;

    RedisKeyFactoryCopyOfLiveNormal(String desc){
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    @Override
    public String toString(){
        return SPACE +SEPARATOR+ this.name();
    }
}
