package cn.com.duiba.kjy.taskcenter.api.constants;

import lombok.Getter;

/**
 * 代理人推送数据行为类型
 *
 * @author 吴文哲
 * @date 2020/11/12 5:02 下午
 **/
@Getter
public enum SellerPushDataActionTypeEnum {

    USER_UPDATE(1, "用户表更新"),
    USER_BATCH_UPDATE_NICKNAME(2, "用户表批量更新昵称"),
    USER_VERSION_INSERT(3, "用户版本表插入"),
    USER_VERSION_UPDATE(4, "用户版本表更新"),
    SELLER_UPDATE(5, "代理人表更新"),
    SELLER_UPDATE_SELLER_NAME(6, "代理人表更新代理人昵称"),
    KJJ_SELLER_BEING_LIVE_AGENT(7, "代理人成为直播代理人"),
    USER_WX_EXT_UPDATE(8, "用户微信拓展信息更新"),
    TRY_PUSH(9, "推送试推"),
    WX_WORK_SELLER_ACTIVATE(10, "企微代理人激活"),
    ;

    /**
     * 描述
     */
    private String desc;

    /**
     * 类型
     */
    private Integer type;

    SellerPushDataActionTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }
}
